  'Aitken Amp meter from ADS1115 - mods marked as DA
  'Make output AIN0-AIN1 - alrady done
  'Shunt is 50mV at 400A i.e. 1mV per 8A
  'Shunt amplifier INA340A1PWR is fixed at x20
  'so we have 20mV per 8A
  'or 1V = 400A i.e. - multiply input by 400 to get Amps
  'ADS1115 Driver for Annex
  'datasheet http://www.ti.com/lit/ds/symlink/ads1115.pdf
  'ADS1115 Registers
  
  'OPTION LCDPANEL ILI9341, L, 2, 23, 6
  'GUI TEST LCDPANEL
  OPTION AUTORUN ON
  OPTION EXPLICIT
  'option lcdpanel ili9341, L, 2, 23, 6
  'gui test lcdpanel
  '6 April 2021 - modify for calibration
  '39A  reads 15A'
  '60A  reads 36A'
  '80A  reads 57A'
  '105A reads 83A'
  '400A reads 386A'
  'y = 0.9725x + 24.568
  CPU 20
  Const ADS1115_ADDRESS    = &h48
  CONST ADS1115_CONV_REG   = 0
  CONST ADS1115_CONF_REG   = 1
  CONST ADS1115_HI_T_REG   = 2
  CONST ADS1115_LO_T_REG   = 3
  
  'Relays
  CONST pinRelay1 = 16
  CONST pinRelay2 = 22
  CONST Switch = 10  
  
  CONST Relay1TurnOn = 0
  CONST Relay1TurnOff = 1 
  CONST Relay2TurnOn = 0
  CONST Relay2TurnOff = 1   
  
  CONST I2C_OPTION = 0
  
  DIM I2C_nBYTES AS INTEGER  
  dim BUFF_IN(2) 'buffer used for read/write to module
  DIM v_meas(8)
  DIM v_big(4)
  DIM v_bigsc(4)
  DIM v_bigscs$(4)
  dim offset(4)  
  DIM v_small,V1,V2       'volts
  DIM nReading
  DIM V3$ AS STRING
  DIM i          'loop counter
  DIM j          'loop counter
  DIM scale
  DIM resistor_scale  
  DIM count_scale
  DIM combined_scale
  DIM correction_scale
  'CONST resistor_error_correction = 0.00
  'i2c.setup 4,5 ' set I2C bus
  
  'Set the ADS1115 with :
  '  AINp = AIN0 and AINn = AIN1
  '  FSR = +/-4.096V
  '  16 SPS
  'ADS115_SETUP(sing_conv,inp_mux, gain, Single_Shot, rate)
  'ADS115_SETUP(
  CONST         SingleConversionOn=1  
  CONST         SingleConversionOff=0
  '             AINP = AIN0 and AINN = AIN3, 
  '             gain = ±4.096 V, 
  CONST         SingleShotOn=1
  CONST         SingleShotOff=0'             Single_Shot = 1, 
  '             rate = 8SPS)
  
  'INPUT MULTIPLEX:
  'AINp is the input positive
  'AINn is the input negative
  CONST AIN0_AIN1 = 0'0 : AINP = AIN0 and AINN = AIN1 (default)
  CONST AIN0_AIN3 = 1'1 : AINP = AIN0 and AINN = AIN3
  CONST AIN1_AIN3 = 2'2 : AINP = AIN1 and AINN = AIN3
  CONST AIN2_AIN3 = 3'3 : AINP = AIN2 and AINN = AIN3
  CONST AIN0_GND  = 4'4 : AINP = AIN0 and AINN = GND
  CONST AIN1_GND  = 5'5 : AINP = AIN1 and AINN = GND
  CONST AIN2_GND  = 6'6 : AINP = AIN2 and AINN = GND
  CONST AIN3_GND  = 7'7 : AINP = AIN3 and AINN = GND 
  
  'GAIN
  CONST FSR6_144 = 0'0 : FSR = ±6.144 V
  CONST FSR4_096 = 1'1 : FSR = ±4.096 V
  CONST FSR2_048 = 2'2 : FSR = ±2.048 V (default)
  CONST FSR1_024 = 3'3 : FSR = ±1.024 V
  CONST FSR0_512 = 4'4 : FSR = ±0.512 V
  CONST FSR0_256 = 5'5 : FSR = ±0.256 V
  '6 : FSR = ±0.256 V
  '7 : FSR = ±0.256 V

  'DATA RATE
  Const SPS8   = 0'0 : 8 SPS
  Const SPS16  = 1'1 : 16 SPS
  Const SPS32  = 2'2 : 32 SPS
  Const SPS64  = 3'3 : 64 SPS
  CONST SPS128 = 4'4 : 128 SPS (default)
  CONST SPS250 = 5'5 : 250 SPS
  Const SPS475 = 6'6 : 475 SPS
  CONST SPS860 = 7'7 : 860 SPS
  
  
  
  'Set Up Relay  Outputs
  pin(pinRelay1) = Relay1TurnOff
  pin(pinRelay2) = Relay1TurnOff 
  
  setpin(pinRelay1), Dout
  setpin(pinRelay2), Dout
  setpin Switch, DIN, Pullup
  
  'Activate Relays  
  pin(pinRelay1) = Relay1TurnOff
  pin(pinRelay2) = Relay1TurnOff

  
  'ADS1115_Setup SingleConversionOff, AIN0_AIN1, FSR2_048, SingleShotOn, SPS128
  'ADS1115_Startconversion
  Pause 200 'Allow 200ms for conversion to complete
  'scale in volt
  'scale = (127/27)*(4.096/32768)
  'nominal resister scale = 127/27 = 4.7
  resistor_scale = 4.7
  count_scale = 4.096/32768 = 0.000125
  correction_scale = 1.00
  combined_scale = 0.0005875
  scale = combined_scale
  DIM RH$ = "12V 4-cell"
  offset(1) = 0.007
  offset(2) = 0.074
  offset(3) = -0.003
  offset(4) = 0.020
 '******************************************MAIN*********************************************** 
for i=0 to 300000000
  If pin(Switch) = 0 Then
    Print "Switch Closed"
  END IF  
  v_meas(AIN0_AIN1) = GETVOLTS(AIN0_AIN1)
  v_meas(AIN1_AIN3) = GETVOLTS(AIN1_AIN3)
  v_meas(AIN2_AIN3) = GETVOLTS(AIN2_AIN3)  
  v_meas(AIN0_GND) = GETVOLTS(AIN0_GND)
  v_meas(AIN1_GND) = GETVOLTS(AIN1_GND)
  v_meas(AIN2_GND) = GETVOLTS(AIN2_GND)
  v_meas(AIN3_GND) = GETVOLTS(AIN3_GND)
  
  v_big(1) = v_meas(AIN0_AIN1)
  v_big(2) = v_meas(AIN1_AIN3) - v_meas(AIN2_AIN3)
  v_big(3) = v_meas(AIN2_AIN3)
  v_big(4) = v_meas(AIN3_GND)
  for nReading = 1 to 4
    v_bigsc(nReading) = v_big(nReading) * scale + offset(nReading)
  Next nReading      

  PRINT v_bigsc(1)
  
  for nReading = 1 to 4
      v_bigscs$(nReading) = STR$(v_bigsc(nReading),2,3)+" "
  Next nReading  
  Text 10,           MM.VRes/16   , "Volts"  , LM, 1, 1 , RGB(GREEN), RGB(BLACK)
  Text MM.HRes*15/32,MM.VRes/16   , RH$     , LM, 1, 1 , RGB(GREEN), RGB(BLACK)

  Text MM.HRes*1/32 ,MM.VRes*10/32, v_bigscs$(1), LM, 1, 3, RGB(BLUE) , RGB(BLACK)
  Text MM.HRes*16/32 ,MM.VRes*10/32, v_bigscs$(2), LM, 1, 3, RGB(BLUE) , RGB(BLACK)  
  Text MM.HRes*1/32 ,MM.VRes*20/32, v_bigscs$(3), LM, 1, 3, RGB(BLUE) , RGB(BLACK)
  Text MM.HRes*16/32 ,MM.VRes*20/32, v_bigscs$(4), LM, 1, 3, RGB(BLUE) , RGB(BLACK)
    

  Text MM.HRes*1/16 ,MM.VRes*7/8  , Time$   , LM, 1, 2 , RGB(GREEN), RGB(BLACK)    
next i

end

 '*********************************************************************************************

FUNCTION GETVOLTS(V_Input)
  local v
  LOCAL count
  LOCAL sum
  v=0
  ADS1115_setup SingleConversionOn, V_Input, FSR4_096, SingleShotOn, SPS8
  Pause 100
  ADS1115_startconversion
  Pause 200 'Allow at least 200ms for conversion to complete
  ADS1115_read v 'read from module
  GETVOLTS = v
END FUNCTION

sub ADS1115_Setup(sing_conv, inp_mux, gain, sing_shot, rate)
  local conf
  I2C OPEN 10,1000 'lowest possible speed 10khz, timeout of 1000ms
  BUFF_IN(1) = (sing_conv<<7) OR (inp_mux<<4)  OR (gain<<1) OR sing_shot
  BUFF_IN(0) = (RATE<<5) OR 3
  
  'Micromite I2C  
  'I2C WRITE addr, option, sendlen, senddata[,senddata...]
  'option is normally 0 - relates to bus control and number of bits in address
  'sendlen is the number of 8-bit bytes to send
  'senddata is the data to be sent
  'e.g. I2C Write &H48,0,3,ARRAY() - 3 bytes
  I2C_nBYTES = 3
  I2C WRITE ADS1115_ADDRESS, I2C_OPTION, I2C_nBYTES, ADS1115_CONF_REG, BUFF_IN(1), BUFF_IN(0)
  'i2c.WriteArray ADS1115_ADDRESS, ADDS1115_CONF_REG, 2, BUFF_IN()
END SUB

SUB ADS1115_Startconversion
  I2C_nBYTES = 1
  I2C write ADS1115_ADDRESS, I2C_OPTION, I2C_nBYTES, ADS1115_CONV_REG
END SUB

SUB ADS1115_read(ret)
  I2C_nBYTES = 2
  I2C READ ADS1115_ADDRESS,I2C_OPTION,I2C_nBYTES, BUFF_IN()
  I2C CLOSE
  ret = BUFF_IN(0)*256+BUFF_IN(1)
  if ret>32768 then ret = ret - 65536
end sub    
